<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateResellerTable extends Migration {

	public function up()
	{
		Schema::create('reseller', function(Blueprint $table) {
			$table->increments('id');
			$table->string('reseller_code', 8);
			$table->string('legal_name');
			$table->string('company_registration', 9);
			$table->string('eu_vat_number');
			$table->float('discount_list_price');
			$table->text('notes');
			$table->boolean('language_french');
			$table->string('company_address_line_1');
			$table->string('company_address_line_2');
			$table->string('company_address_postal_code', 7);
			$table->string('company_address_city_name');
			$table->string('company_address_country');
			$table->string('contact_sales_name');
			$table->string('contact_sales_phone');
			$table->string('contact_sales_mail');
			$table->string('contact_accounting_name');
			$table->string('contact_accounting_phone');
			$table->string('contact_accounting_mail');
			$table->string('contact_purchasing_name');
			$table->string('contact_purchasing_mail');
			$table->string('contact_purchasing_phone');
			$table->integer('user_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('reseller');
	}
}