<?php

namespace App/Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Guarantee extends Eloquent {

	protected $table = 'guarantees';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function model()
	{
		return $this->belongsTo('Model');
	}

	public function product()
	{
		return $this->belongsTo('Product');
	}

	public function user()
	{
		return $this->belongsTo('User');
	}

}