<?php

namespace App/Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Model extends Eloquent {

	protected $table = 'models';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function guarantees()
	{
		return $this->hasMany('Guarantee');
	}

	public function make()
	{
		return $this->belongsTo('Make');
	}

}