<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Project extends Model 
{

    protected $table = 'project';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function script_type()
    {
        return $this->belongsToMany('Models\ScriptType', 'project_script_type', 'script_type_id', 'project_id');
    }

    public function payment_method()
    {
        return $this->belongsTo('Models\ProjectPayment');
    }

    public function dns()
    {
        return $this->hasMany('Models\Dns');
    }

    public function tags()
    {
        return $this->belongsToMany('Models\Tag', 'ProjectTag', 'tag_id', 'project_id');
    }

    public function server_detail()
    {
        return $this->belongsToMany('Models\ServerDetail', 'project_server_detail', 'server_detail_id', 'project_id');
    }

}