<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProjectPayment extends Model 
{

    protected $table = 'project_payment';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function payment()
    {
        return $this->belongsTo('Models\Payment', 'payment_id');
    }

    public function project()
    {
        return $this->hasMany('Models\Project');
    }

}