<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdminTable extends Migration {

	public function up()
	{
		Schema::create('admin', function(Blueprint $table) {
			$table->increments('admin_id');
			$table->string('admin_name', 255)->nullable();
			$table->string('admin_email', 255)->unique();
			$table->string('admin_pasword');
			$table->tinyInteger('admin_role');
			$table->tinyInteger('admin_status');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('admin');
	}
}