<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLessonsTable extends Migration {

	public function up()
	{
		Schema::create('lessons', function(Blueprint $table) {
			$table->increments('lesson_id');
			$table->tinyInteger('lesson_status');
			$table->string('lesson_no');
			$table->string('lesson_title')->nullable();
			$table->integer('fk_course_id')->unsigned();
			$table->integer('lesson_level_id')->nullable();
			$table->text('lesson_sumary')->nullable();
			$table->text('lesson_guide')->nullable();
			$table->string('lesson_admin_note')->nullable();
			$table->string('lesson_area')->nullable();
			$table->string('lesson_subject')->nullable();
			$table->datetime('lesson_result_public_date')->nullable();
			$table->datetime('lesson_test_date');
			$table->tinyInteger('lesson_test_status');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('lessons');
	}
}