<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMerAttributeTable extends Migration {

	public function up()
	{
		Schema::create('mer_attribute', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('code', 100)->nullable();
			$table->string('name', 255)->nullable();
			$table->tinyInteger('is_active')->default('0');
			$table->string('description', 255)->nullable();
			$table->string('type', 100)->nullable();
			$table->double('unit_cost', 10,4)->nullable();
			$table->double('unit_price')->nullable();
			$table->double('all_price', 12,2)->nullable();
			$table->double('weight', 10,4)->nullable();
			$table->string('small_image', 255)->nullable();
			$table->string('larage_image', 255)->nullable();
			$table->bigInteger('option_id')->unsigned()->nullable();
			$table->tinyInteger('is_required')->default('0');
			$table->tinyInteger('attribute_order')->default('0');
			$table->string('scope', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('mer_attribute');
	}
}