<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMerOptionTable extends Migration {

	public function up()
	{
		Schema::create('mer_option', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('attribute_id')->unsigned()->nullable();
			$table->string('code', 100)->nullable();
			$table->string('name', 255)->nullable();
			$table->string('description', 255)->nullable();
			$table->double('unit_cost', 10,4)->nullable();
			$table->double('unit_price', 10,4)->nullable();
			$table->double('all_price', 12,2)->nullable();
			$table->double('weight')->nullable();
			$table->string('small_image', 255)->nullable();
			$table->string('larage_image', 255)->nullable();
			$table->integer('option_order')->default('0');
			$table->string('scope', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('mer_option');
	}
}