<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMerProductSettingTable extends Migration {

	public function up()
	{
		Schema::create('mer_product_setting', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('code', 100)->nullable();
			$table->string('name', 255)->nullable();
			$table->string('description', 255)->nullable();
			$table->tinyInteger('is_active')->default('0');
			$table->integer('integer_value')->nullable();
			$table->string('small_value', 64)->nullable();
			$table->string('larage_value', 255)->nullable();
			$table->string('type', 100)->nullable();
			$table->string('scope', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('mer_product_setting');
	}
}