<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMerCategoryTable extends Migration {

	public function up()
	{
		Schema::create('mer_category', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('code', 100)->nullable();
			$table->string('name', 255)->nullable();
			$table->string('keywords', 255)->nullable();
			$table->text('description')->nullable();
			$table->tinyInteger('is_active')->nullable()->default('0');
			$table->bigInteger('category_itree_d')->unsigned()->nullable();
			$table->string('header', 255)->nullable();
			$table->string('footer', 255)->nullable();
			$table->string('small_image', 255)->nullable();
			$table->string('medium_image', 255)->nullable();
			$table->string('larage_image', 255)->nullable();
			$table->string('extra1', 255)->nullable();
			$table->string('extra2', 255)->nullable();
			$table->string('extra3', 255)->nullable();
			$table->bigInteger('parent_category_id')->unsigned()->nullable();
			$table->integer('category_order')->default('0');
			$table->string('scope', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('mer_category');
	}
}