<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMerDiscountsTable extends Migration {

	public function up()
	{
		Schema::create('mer_discounts', function(Blueprint $table) {
			$table->timestamps();
			$table->bigIncrements('id');
			$table->softDeletes();
			$table->string('code', 100)->nullable();
			$table->string('name', 255)->nullable();
			$table->text('description')->nullable();
			$table->tinyInteger('is_active')->default('0');
			$table->string('user_applies_type', 32)->nullable();
			$table->string('user_applies_value', 255)->nullable();
			$table->string('item_applies_type', 32)->nullable();
			$table->string('item_applies_value', 255)->nullable();
			$table->string('reward_type', 32)->nullable();
			$table->string('reward', 255)->nullable();
			$table->string('coupon_code', 100)->nullable();
			$table->datetime('start_date')->nullable();
			$table->datetime('expiration_date')->nullable();
			$table->integer('times_used')->nullable();
			$table->integer('max_times_used')->nullable();
			$table->tinyInteger('is_times_per_customer')->default('0');
			$table->integer('discount_order')->default('0');
			$table->string('extra1', 255)->nullable();
			$table->string('extra2', 255)->nullable();
			$table->string('extra3', 255)->nullable();
			$table->string('scope', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('mer_discounts');
	}
}