<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUnitsTable extends Migration {

	public function up()
	{
		Schema::create('units', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('unit_name', 100);
			$table->string('device_code', 255)->nullable();
			$table->integer('company_id')->unsigned();
			$table->integer('location_id')->unsigned();
			$table->string('pass_key', 255)->nullable();
			$table->string('email', 255)->nullable();
			$table->smallInteger('no_of_cam')->default('10');
		});
	}

	public function down()
	{
		Schema::drop('units');
	}
}