<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('locations', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('locations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('unit_logs', function(Blueprint $table) {
			$table->foreign('unit_id')->references('id')->on('units')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('unit_logs', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('unit_logs', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('locations')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('unit_images', function(Blueprint $table) {
			$table->foreign('unit_id')->references('id')->on('units')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('unit_images', function(Blueprint $table) {
			$table->foreign('group_id')->references('id')->on('unit_groups')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('unit_groups', function(Blueprint $table) {
			$table->foreign('unit_id')->references('id')->on('units')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('unit_status_logs', function(Blueprint $table) {
			$table->foreign('unit_id')->references('id')->on('units')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('unit_schedules', function(Blueprint $table) {
			$table->foreign('unit_id')->references('id')->on('units')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_company_id_foreign');
		});
		Schema::table('locations', function(Blueprint $table) {
			$table->dropForeign('locations_company_id_foreign');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->dropForeign('units_company_id_foreign');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->dropForeign('units_location_id_foreign');
		});
		Schema::table('unit_logs', function(Blueprint $table) {
			$table->dropForeign('unit_logs_unit_id_foreign');
		});
		Schema::table('unit_logs', function(Blueprint $table) {
			$table->dropForeign('unit_logs_company_id_foreign');
		});
		Schema::table('unit_logs', function(Blueprint $table) {
			$table->dropForeign('unit_logs_location_id_foreign');
		});
		Schema::table('unit_images', function(Blueprint $table) {
			$table->dropForeign('unit_images_unit_id_foreign');
		});
		Schema::table('unit_images', function(Blueprint $table) {
			$table->dropForeign('unit_images_group_id_foreign');
		});
		Schema::table('unit_groups', function(Blueprint $table) {
			$table->dropForeign('unit_groups_unit_id_foreign');
		});
		Schema::table('unit_status_logs', function(Blueprint $table) {
			$table->dropForeign('unit_status_logs_unit_id_foreign');
		});
		Schema::table('unit_schedules', function(Blueprint $table) {
			$table->dropForeign('unit_schedules_unit_id_foreign');
		});
	}
}