<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('fname', 'lname', 'role', 'email');
	protected $visible = array('fname', 'lname', 'role', 'email');

	public function company()
	{
		return $this->belongsTo('App\Company');
	}

}