<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompaniesTable extends Migration {

	public function up()
	{
		Schema::create('companies', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('company_name', 100);
			$table->string('addr_line_1', 255)->nullable();
			$table->string('addr_line_2', 255)->nullable();
			$table->string('website', 255)->nullable();
			$table->string('email', 255)->nullable();
			$table->string('phone_no', 30)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('companies');
	}
}