<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('fname', 100);
			$table->string('lname', 100)->nullable();
			$table->enum('role', array('admin', 'client', 'owner', 'master'));
			$table->string('email', 255)->unique()->nullable();
			$table->string('salt', 255);
			$table->string('password', 255);
			$table->integer('company_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}