<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCourseLogTable extends Migration {

	public function up()
	{
		Schema::create('course_log', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('admin_id')->unsigned()->nullable()->index();
			$table->bigInteger('user_id')->unsigned()->nullable()->index();
			$table->string('column_name');
			$table->string('old_value');
			$table->string('new_value');
			$table->enum('status', array('review', 'approved'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('course_log');
	}
}