<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;

class League extends Model 
{

    protected $table = 'leagues';
    public $timestamps = true;

    public function league_schedules()
    {
        return $this->hasMany('Models\LeagueSchedule', 'league_id', 'id');
    }

    public function rules()
    {
        return $this->hasMany('Models\LeagueRule', 'league_id', 'id');
    }

    public function invitations()
    {
        return $this->hasMany('Models\Invitation', 'league_id', 'id');
    }

    public function user()
    {
        return $this->belongsTo('Models\User', 'creator_id', 'id');
    }

    public function teams()
    {
        return $this->hasMany('Models\Team', 'league_id', 'id');
    }

}