<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Client extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;
    protected $fillable = array('name', 'email', 'phone', 'date_of_birth', 'activated', 'date_of_last_donation', 'city_id', 'is_read');

    public function city()
    {
        return $this->belongsTo('App\City');
    }

    public function governorates()
    {
        return $this->belongsToMany('App\Governorate');
    }

    public function posts()
    {
        return $this->belongsToMany('App\Post');
    }

    public function blood_types()
    {
        return $this->belongsToMany('App\BloodType');
    }

    public function notifications()
    {
        return $this->belongsToMany('App\Notification');
    }

    public function donationRequests()
    {
        return $this->hasMany('App\DonationRequest');
    }

    public function contacts()
    {
        return $this->hasMany('App\Contact');
    }

    public function bloodType()
    {
        return $this->belongsTo('App\BloodType');
    }

}