<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientsTable extends Migration {

	public function up()
	{
		Schema::create('clients', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->string('email');
			$table->string('phone');
			$table->string('password');
			$table->date('date_of_birth');
			$table->tinyInteger('activated');
			$table->string('api_token');
			$table->date('date_of_last_donation');
			$table->integer('city_id');
			$table->boolean('is_read');
		});
	}

	public function down()
	{
		Schema::drop('clients');
	}
}