<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class DetailEntreeProduit extends Model 
{

    protected $table = 'details_entree_produit';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function entreeProduit()
    {
        return $this->hasOne('EntreeProduit');
    }

    public function fournisseur()
    {
        return $this->hasOne('Fournisseur');
    }

    public function produit()
    {
        return $this->hasOne('Produit');
    }

}