<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class DetailVenteProduit extends Eloquent {

	protected $table = 'details_vente_produit';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function client()
	{
		return $this->hasOne('Client');
	}

	public function venteProduit()
	{
		return $this->hasOne('VenteProduit');
	}

	public function produit()
	{
		return $this->hasOne('Produit');
	}

}