<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('application_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('store_id')->references('id')->on('application_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_infos', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('car_models', function(Blueprint $table) {
			$table->foreign('brand_id')->references('id')->on('application_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_rates', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_rates', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('application_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('captains', function(Blueprint $table) {
			$table->foreign('store_id')->references('id')->on('application_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('captain_infos', function(Blueprint $table) {
			$table->foreign('car_model_id')->references('id')->on('car_models')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('captain_infos', function(Blueprint $table) {
			$table->foreign('car_class_id')->references('id')->on('car_classes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('captain_infos', function(Blueprint $table) {
			$table->foreign('captain_id')->references('id')->on('application_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('stores', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('application_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('captain_rates', function(Blueprint $table) {
			$table->foreign('captain_id')->references('id')->on('application_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_infos', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('store_user_subscriptions', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('application_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('store_user_subscriptions', function(Blueprint $table) {
			$table->foreign('store_package_id')->references('id')->on('application_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->foreign('store_id')->references('id')->on('application_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('store_advertisements', function(Blueprint $table) {
			$table->foreign('store_id')->references('id')->on('stores')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('chats', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('chats', function(Blueprint $table) {
			$table->foreign('captain_id')->references('id')->on('captains')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('chat_messages', function(Blueprint $table) {
			$table->foreign('chat_id')->references('id')->on('captains')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_addresses', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_driver_offers', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_driver_offers', function(Blueprint $table) {
			$table->foreign('captain_id')->references('id')->on('captains')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_driver_offers', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_schedul_repeats', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('application_category_services', function(Blueprint $table) {
			$table->foreign('application_category_id')->references('id')->on('application_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_user_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_store_id_foreign');
		});
		Schema::table('order_infos', function(Blueprint $table) {
			$table->dropForeign('order_infos_order_id_foreign');
		});
		Schema::table('car_models', function(Blueprint $table) {
			$table->dropForeign('car_models_brand_id_foreign');
		});
		Schema::table('product_rates', function(Blueprint $table) {
			$table->dropForeign('product_rates_product_id_foreign');
		});
		Schema::table('product_rates', function(Blueprint $table) {
			$table->dropForeign('product_rates_user_id_foreign');
		});
		Schema::table('captains', function(Blueprint $table) {
			$table->dropForeign('captains_store_id_foreign');
		});
		Schema::table('captain_infos', function(Blueprint $table) {
			$table->dropForeign('captain_infos_car_model_id_foreign');
		});
		Schema::table('captain_infos', function(Blueprint $table) {
			$table->dropForeign('captain_infos_car_class_id_foreign');
		});
		Schema::table('captain_infos', function(Blueprint $table) {
			$table->dropForeign('captain_infos_captain_id_foreign');
		});
		Schema::table('stores', function(Blueprint $table) {
			$table->dropForeign('stores_city_id_foreign');
		});
		Schema::table('captain_rates', function(Blueprint $table) {
			$table->dropForeign('captain_rates_captain_id_foreign');
		});
		Schema::table('user_infos', function(Blueprint $table) {
			$table->dropForeign('user_infos_user_id_foreign');
		});
		Schema::table('store_user_subscriptions', function(Blueprint $table) {
			$table->dropForeign('store_user_subscriptions_user_id_foreign');
		});
		Schema::table('store_user_subscriptions', function(Blueprint $table) {
			$table->dropForeign('store_user_subscriptions_store_package_id_foreign');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->dropForeign('employees_store_id_foreign');
		});
		Schema::table('store_advertisements', function(Blueprint $table) {
			$table->dropForeign('store_advertisements_store_id_foreign');
		});
		Schema::table('chats', function(Blueprint $table) {
			$table->dropForeign('chats_user_id_foreign');
		});
		Schema::table('chats', function(Blueprint $table) {
			$table->dropForeign('chats_captain_id_foreign');
		});
		Schema::table('chat_messages', function(Blueprint $table) {
			$table->dropForeign('chat_messages_chat_id_foreign');
		});
		Schema::table('user_addresses', function(Blueprint $table) {
			$table->dropForeign('user_addresses_user_id_foreign');
		});
		Schema::table('order_driver_offers', function(Blueprint $table) {
			$table->dropForeign('order_driver_offers_order_id_foreign');
		});
		Schema::table('order_driver_offers', function(Blueprint $table) {
			$table->dropForeign('order_driver_offers_captain_id_foreign');
		});
		Schema::table('order_driver_offers', function(Blueprint $table) {
			$table->dropForeign('order_driver_offers_user_id_foreign');
		});
		Schema::table('order_schedul_repeats', function(Blueprint $table) {
			$table->dropForeign('order_schedul_repeats_order_id_foreign');
		});
		Schema::table('application_category_services', function(Blueprint $table) {
			$table->dropForeign('application_category_services_application_category_id_foreign');
		});
	}
}