<?php

namespace App\Model;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class EmailQueue extends Eloquent {

	protected $table = 'email_queue';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function status()
	{
		return $this->belongsTo('App\Model\EmailSendingStatuses', 'status_id');
	}

	public function sender()
	{
		return $this->belongsTo('App\Model\Employee', 'sender_id');
	}

}