<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCommonQuestionsTable extends Migration {

	public function up()
	{
		Schema::create('common_questions', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name')->nullable();
			$table->string('email')->nullable();
			$table->text('question')->nullable();
			$table->text('answer')->nullable();
			$table->enum('show', array(''true'', ''false''))->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('common_questions');
	}
}