<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCourseRequestsTable extends Migration {

	public function up()
	{
		Schema::create('course_requests', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('course_id')->unsigned();
			$table->enum('payment_type', array(''visa'', ''bank'', ''paypal'', ''zbony'', ''sala''))->nullable();
			$table->enum('paid', array(''free'', ''paid''))->nullable();
			$table->enum('admin_accept', array(''pending'', ''accepted'', ''refused''))->nullable();
			$table->string('price')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('course_requests');
	}
}