<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCoursesTable extends Migration {

	public function up()
	{
		Schema::create('courses', function(Blueprint $table) {
			$table->increments('id');
			$table->json('title')->nullable();
			$table->integer('category_id')->unsigned();
			$table->json('description')->nullable();
			$table->enum('piad', array(''true'', ''false''))->nullable();
			$table->string('price')->nullable();
			$table->date('start_date')->nullable();
			$table->date('end_date')->nullable();
			$table->string('course_code')->nullable();
			$table->text('zoom_link');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('courses');
	}
}