<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTokensTable extends Migration {

	public function up()
	{
		Schema::create('tokens', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->string('token')->nullable();
			$table->enum('device_type', array(''ios'', ''android''))->nullable();
			$table->enum('device_lang', array(''ar'', ''en''))->nullable();
			$table->enum('status', array(''connected'', ''disconnected''))->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('tokens');
	}
}