<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('tokens', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('courses', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('course_dayes', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('course_requests', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('course_requests', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('payment_transfers', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('payment_transfers', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('payment_transfers', function(Blueprint $table) {
			$table->foreign('course_request_id')->references('id')->on('course_requests')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('payment_transfers', function(Blueprint $table) {
			$table->foreign('bank_id')->references('id')->on('banks')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('user_courses', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('user_courses', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('user_courses', function(Blueprint $table) {
			$table->foreign('course_request_id')->references('id')->on('course_requests')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('rates', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('rates', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('course_documents', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('reference_summaries', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('revision_requests', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('revision_requests', function(Blueprint $table) {
			$table->foreign('revision_price_id')->references('id')->on('revision_prices')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('revision_requests', function(Blueprint $table) {
			$table->foreign('bank_id')->references('id')->on('banks')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('download_requests', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('download_requests', function(Blueprint $table) {
			$table->foreign('topic_liberary_id')->references('id')->on('topic_liberaries')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('download_requests', function(Blueprint $table) {
			$table->foreign('bank_id')->references('id')->on('banks')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('user_topics', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('user_topics', function(Blueprint $table) {
			$table->foreign('topic_liberary_id')->references('id')->on('topic_liberaries')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_country_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_category_id_foreign');
		});
		Schema::table('tokens', function(Blueprint $table) {
			$table->dropForeign('tokens_user_id_foreign');
		});
		Schema::table('courses', function(Blueprint $table) {
			$table->dropForeign('courses_category_id_foreign');
		});
		Schema::table('course_dayes', function(Blueprint $table) {
			$table->dropForeign('course_dayes_course_id_foreign');
		});
		Schema::table('course_requests', function(Blueprint $table) {
			$table->dropForeign('course_requests_user_id_foreign');
		});
		Schema::table('course_requests', function(Blueprint $table) {
			$table->dropForeign('course_requests_course_id_foreign');
		});
		Schema::table('payment_transfers', function(Blueprint $table) {
			$table->dropForeign('payment_transfers_course_id_foreign');
		});
		Schema::table('payment_transfers', function(Blueprint $table) {
			$table->dropForeign('payment_transfers_user_id_foreign');
		});
		Schema::table('payment_transfers', function(Blueprint $table) {
			$table->dropForeign('payment_transfers_course_request_id_foreign');
		});
		Schema::table('payment_transfers', function(Blueprint $table) {
			$table->dropForeign('payment_transfers_bank_id_foreign');
		});
		Schema::table('user_courses', function(Blueprint $table) {
			$table->dropForeign('user_courses_user_id_foreign');
		});
		Schema::table('user_courses', function(Blueprint $table) {
			$table->dropForeign('user_courses_course_id_foreign');
		});
		Schema::table('user_courses', function(Blueprint $table) {
			$table->dropForeign('user_courses_course_request_id_foreign');
		});
		Schema::table('rates', function(Blueprint $table) {
			$table->dropForeign('rates_user_id_foreign');
		});
		Schema::table('rates', function(Blueprint $table) {
			$table->dropForeign('rates_course_id_foreign');
		});
		Schema::table('course_documents', function(Blueprint $table) {
			$table->dropForeign('course_documents_course_id_foreign');
		});
		Schema::table('reference_summaries', function(Blueprint $table) {
			$table->dropForeign('reference_summaries_category_id_foreign');
		});
		Schema::table('revision_requests', function(Blueprint $table) {
			$table->dropForeign('revision_requests_user_id_foreign');
		});
		Schema::table('revision_requests', function(Blueprint $table) {
			$table->dropForeign('revision_requests_revision_price_id_foreign');
		});
		Schema::table('revision_requests', function(Blueprint $table) {
			$table->dropForeign('revision_requests_bank_id_foreign');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->dropForeign('notifications_user_id_foreign');
		});
		Schema::table('download_requests', function(Blueprint $table) {
			$table->dropForeign('download_requests_user_id_foreign');
		});
		Schema::table('download_requests', function(Blueprint $table) {
			$table->dropForeign('download_requests_topic_liberary_id_foreign');
		});
		Schema::table('download_requests', function(Blueprint $table) {
			$table->dropForeign('download_requests_bank_id_foreign');
		});
		Schema::table('user_topics', function(Blueprint $table) {
			$table->dropForeign('user_topics_user_id_foreign');
		});
		Schema::table('user_topics', function(Blueprint $table) {
			$table->dropForeign('user_topics_topic_liberary_id_foreign');
		});
	}
}