<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOffresTable extends Migration {

	public function up()
	{
		Schema::create('offres', function(Blueprint $table) {
			$table->string('offre_id')->unique()->primary();
			$table->string('nom');
			$table->date('date_demande');
			$table->string('client_beneficiaire')->nullable();
			$table->string('formations_concernees')->nullable();
			$table->string('etat_offre')->nullable();
			$table->string('formateur_designe')->nullable();
			$table->string('disponibilite_support')->nullable();
			$table->string('etat_realistaion')->nullable();
			$table->string('observation')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('offres');
	}
}