<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ShippingInsuranceRange extends Model 
{

    protected $table = 'shipping_insurance_ranges';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('value_from', 'value_until', 'price');

    public function insurance()
    {
        return $this->belongsTo('ShippingInsurance');
    }

}