<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ShippingPlace extends Model 
{

    protected $table = 'shipping_places';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('shipping_product_id', 'name', 'name-slug', 'longitude', 'latitude', 'dropoff', 'pickup');

    public function products()
    {
        return $this->belongsToMany('ShippingProduct');
    }

    public function city()
    {
        return $this->hasOne('City');
    }

}