<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateShippingRateRangesTable extends Migration {

	public function up()
	{
		Schema::create('shipping_rate_ranges', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('shipping_rate_id')->unsigned();
			$table->integer('weight_from')->nullable();
			$table->integer('weight_until')->nullable();
			$table->decimal('price', 8,2)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('shipping_rate_ranges');
	}
}