<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateShippingPlacesTable extends Migration {

	public function up()
	{
		Schema::create('shipping_places', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('shipping_product_id')->unsigned()->nullable();
			$table->string('name', 50)->nullable();
			$table->string('name-slug', 50)->nullable();
			$table->decimal('longitude', 10,6)->nullable();
			$table->decimal('latitude', 10,6)->nullable();
			$table->boolean('dropoff');
			$table->boolean('pickup');
			$table->integer('city_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('shipping_places');
	}
}