<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ShippingRateRange extends Model 
{

    protected $table = 'shipping_rate_ranges';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('weight_from', 'weight_until', 'price');

    public function rate()
    {
        return $this->belongsTo('ShippingRate');
    }

}