<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateShippingInsuranceRangesTable extends Migration {

	public function up()
	{
		Schema::create('shipping_insurance_ranges', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('shipping_insurance_id')->unsigned();
			$table->integer('value_from')->nullable();
			$table->integer('value_until')->nullable();
			$table->decimal('price', 8,2)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('shipping_insurance_ranges');
	}
}