<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('shipping_products', function(Blueprint $table) {
			$table->foreign('shipping_company')->references('id')->on('shipping_companies')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('shipping_rate_ranges', function(Blueprint $table) {
			$table->foreign('shipping_rate_id')->references('id')->on('shipping_rates')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('shipping_rates', function(Blueprint $table) {
			$table->foreign('shipping_product_id')->references('id')->on('shipping_products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('shipping_rates', function(Blueprint $table) {
			$table->foreign('country_from')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('shipping_rates', function(Blueprint $table) {
			$table->foreign('country_to')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('shipping_insurances', function(Blueprint $table) {
			$table->foreign('shipping_rate_id')->references('id')->on('shipping_rates')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('shipping_insurance_ranges', function(Blueprint $table) {
			$table->foreign('shipping_insurance_id')->references('id')->on('shipping_insurances')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('shipping_places', function(Blueprint $table) {
			$table->foreign('shipping_product_id')->references('id')->on('shipping_products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('shipping_places', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('shipping_labels', function(Blueprint $table) {
			$table->foreign('shipping_product_id')->references('id')->on('shipping_products')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('shipping_products', function(Blueprint $table) {
			$table->dropForeign('shipping_products_shipping_company_foreign');
		});
		Schema::table('shipping_rate_ranges', function(Blueprint $table) {
			$table->dropForeign('shipping_rate_ranges_shipping_rate_id_foreign');
		});
		Schema::table('shipping_rates', function(Blueprint $table) {
			$table->dropForeign('shipping_rates_shipping_product_id_foreign');
		});
		Schema::table('shipping_rates', function(Blueprint $table) {
			$table->dropForeign('shipping_rates_country_from_foreign');
		});
		Schema::table('shipping_rates', function(Blueprint $table) {
			$table->dropForeign('shipping_rates_country_to_foreign');
		});
		Schema::table('shipping_insurances', function(Blueprint $table) {
			$table->dropForeign('shipping_insurances_shipping_rate_id_foreign');
		});
		Schema::table('shipping_insurance_ranges', function(Blueprint $table) {
			$table->dropForeign('shipping_insurance_ranges_shipping_insurance_id_foreign');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->dropForeign('cities_country_id_foreign');
		});
		Schema::table('shipping_places', function(Blueprint $table) {
			$table->dropForeign('shipping_places_shipping_product_id_foreign');
		});
		Schema::table('shipping_places', function(Blueprint $table) {
			$table->dropForeign('shipping_places_city_id_foreign');
		});
		Schema::table('shipping_labels', function(Blueprint $table) {
			$table->dropForeign('shipping_labels_shipping_product_id_foreign');
		});
	}
}