<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('faqs', function(Blueprint $table) {
			$table->foreign('company_id')->references('timestamps')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('faqs', function(Blueprint $table) {
			$table->foreign('job_vacancy_id')->references('id')->on('job_vacancies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('faqs', function(Blueprint $table) {
			$table->dropForeign('faqs_company_id_foreign');
		});
		Schema::table('faqs', function(Blueprint $table) {
			$table->dropForeign('faqs_job_vacancy_id_foreign');
		});
	}
}