<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTasksTable extends Migration {

	public function up()
	{
		Schema::create('tasks', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('description');
			$table->datetime('start_date');
			$table->datetime('due_date');
			$table->json('assignees');
			$table->integer('account_id');
			$table->string('status');
			$table->integer('deal_id');
			$table->float('cost');
			$table->integer('weight');
			$table->string('expected_bonus');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('tasks');
	}
}