<?php

namespace App\Models\Contact;

class Contact extends Eloquent {

	protected $table = 'contacts';
	public $timestamps = true;

	public function account()
	{
		return $this->belongsTo('Account');
	}

	public function contactProjects()
	{
		return $this->belongsToMany('ContactProject', 'contact_id');
	}

	public function contactDeals()
	{
		return $this->belongsToMany('ContactDeal', 'contact_id');
	}

	public function contactEvents()
	{
		return $this->belongsToMany('ContactEvent', 'contact_id');
	}

	public function contactTasks()
	{
		return $this->belongsToMany('ContactTask', 'contact_id');
	}

	public function jobTitle()
	{
		return $this->hasOne('Job', 'job_id');
	}

}