<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('name')->nullable();
			$table->string('mobile')->nullable();
			$table->string('email')->nullable();
			$table->string('image')->nullable();
			$table->enum('type', array('client', 'merchant'))->nullable();
			$table->string('password')->nullable();
			$table->enum('status', array('active', 'not_active'))->nullable();
			$table->string('market_link')->nullable();
			$table->string('commercial_image')->nullable();
			$table->string('verification_code')->nullable();
			$table->enum('verification_status', array('true', 'false'))->nullable();
			$table->string('wallet')->nullable();
			$table->string('points')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}