<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePointCartsTable extends Migration {

	public function up()
	{
		Schema::create('point_carts', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('point_product_id')->unsigned()->nullable();
			$table->string('total_points')->nullable();
			$table->enum('status', array('waiting', 'new', 'finished', 'cancel'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('point_carts');
	}
}