<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('departements', function(Blueprint $table) {
			$table->foreign('region_id')->references('id')->on('regions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('villes', function(Blueprint $table) {
			$table->foreign('departement_id')->references('id')->on('departements')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('sous_prefectures', function(Blueprint $table) {
			$table->foreign('ville_id')->references('id')->on('villes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('villages', function(Blueprint $table) {
			$table->foreign('sous_prefecture_id')->references('id')->on('sous_prefectures')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('acquereurs', function(Blueprint $table) {
			$table->foreign('nationalite_id')->references('id')->on('nationalites')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('proprietaires', function(Blueprint $table) {
			$table->foreign('nationalite_id')->references('id')->on('nationalites')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('proprietaires', function(Blueprint $table) {
			$table->foreign('agent_id')->references('id')->on('agents')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lotissements', function(Blueprint $table) {
			$table->foreign('type_loti_id')->references('id')->on('type_lotissements')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lotissements', function(Blueprint $table) {
			$table->foreign('entreprise_id')->references('id')->on('entreprises')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lotissements', function(Blueprint $table) {
			$table->foreign('village_id')->references('id')->on('villages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lotissements', function(Blueprint $table) {
			$table->foreign('agent_id')->references('id')->on('agents')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ilots', function(Blueprint $table) {
			$table->foreign('lotissement_id')->references('id')->on('lotissements')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ilots', function(Blueprint $table) {
			$table->foreign('agent_id')->references('id')->on('agents')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lots', function(Blueprint $table) {
			$table->foreign('ilot_id')->references('id')->on('ilots')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('acquisitions', function(Blueprint $table) {
			$table->foreign('proprietaire_id')->references('id')->on('proprietaires')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('acquisitions', function(Blueprint $table) {
			$table->foreign('lot_id')->references('id')->on('lots')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('departements', function(Blueprint $table) {
			$table->dropForeign('departements_region_id_foreign');
		});
		Schema::table('villes', function(Blueprint $table) {
			$table->dropForeign('villes_departement_id_foreign');
		});
		Schema::table('sous_prefectures', function(Blueprint $table) {
			$table->dropForeign('sous_prefectures_ville_id_foreign');
		});
		Schema::table('villages', function(Blueprint $table) {
			$table->dropForeign('villages_sous_prefecture_id_foreign');
		});
		Schema::table('acquereurs', function(Blueprint $table) {
			$table->dropForeign('acquereurs_nationalite_id_foreign');
		});
		Schema::table('proprietaires', function(Blueprint $table) {
			$table->dropForeign('proprietaires_nationalite_id_foreign');
		});
		Schema::table('proprietaires', function(Blueprint $table) {
			$table->dropForeign('proprietaires_agent_id_foreign');
		});
		Schema::table('lotissements', function(Blueprint $table) {
			$table->dropForeign('lotissements_type_loti_id_foreign');
		});
		Schema::table('lotissements', function(Blueprint $table) {
			$table->dropForeign('lotissements_entreprise_id_foreign');
		});
		Schema::table('lotissements', function(Blueprint $table) {
			$table->dropForeign('lotissements_village_id_foreign');
		});
		Schema::table('lotissements', function(Blueprint $table) {
			$table->dropForeign('lotissements_agent_id_foreign');
		});
		Schema::table('ilots', function(Blueprint $table) {
			$table->dropForeign('ilots_lotissement_id_foreign');
		});
		Schema::table('ilots', function(Blueprint $table) {
			$table->dropForeign('ilots_agent_id_foreign');
		});
		Schema::table('lots', function(Blueprint $table) {
			$table->dropForeign('lots_ilot_id_foreign');
		});
		Schema::table('acquisitions', function(Blueprint $table) {
			$table->dropForeign('acquisitions_proprietaire_id_foreign');
		});
		Schema::table('acquisitions', function(Blueprint $table) {
			$table->dropForeign('acquisitions_lot_id_foreign');
		});
	}
}