<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class DonationRequests extends Model 
{

    protected $table = 'donation_requests';
    public $timestamps = true;
    protected $fillable = array('client_id', 'name', 'age', 'blood_type_id', 'number_bags', 'hospital_name', 'town_id', 'phone', 'latitude', 'longitude', 'notes', 'governorate_id');

    public function client()
    {
        return $this->belongsTo('App\Client');
    }

    public function blood_type()
    {
        return $this->belongsTo('App\BloodType');
    }

    public function notifications()
    {
        return $this->hasMany('App\Notification');
    }

    public function governorate()
    {
        return $this->belongsTo('App\Governorate');
    }

}