<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuestsTable extends Migration {

	public function up()
	{
		Schema::create('quests', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('city_id')->unsigned();
			$table->string('title', 100);
			$table->text('description');
			$table->text('rules');
			$table->string('duration', 20);
			$table->string('break_time', 20);
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('quests');
	}
}