<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Posicion extends Model 
{

    protected $table = 'posicion';
    public $timestamps = false;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function viaje()
    {
        return $this->belongsTo('Viaje');
    }

    public function envio()
    {
        return $this->hasMany('Envio');
    }

    public function localidad()
    {
        return $this->hasOne('Localidad');
    }

}