<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEnviosTable extends Migration {

	public function up()
	{
		Schema::create('envios', function(Blueprint $table) {
			$table->increments('id');
			$table->string('descripcion');
			$table->timestamps();
			$table->string('codigo_seguimiento')->unique()->nullable();
			$table->softDeletes();
			$table->integer('estado_id')->unsigned()->nullable();
			$table->integer('usuario_id')->unsigned()->nullable();
			$table->integer('punto_recogida_id')->unsigned()->nullable();
			$table->integer('punto_entrega_id')->unsigned()->nullable();
			$table->integer('cobertura_id')->unsigned()->nullable();
			$table->integer('destinatario_id')->unsigned()->nullable();
			$table->integer('pago_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('envios');
	}
}