<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsuariosTable extends Migration {

	public function up()
	{
		Schema::create('usuarios', function(Blueprint $table) {
			$table->increments('id');
			$table->string('usuario', 16)->unique();
			$table->string('password');
			$table->string('email')->unique();
			$table->softDeletes();
			$table->rememberToken();
			$table->timestamps();
			$table->integer('configuracion_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('usuarios');
	}
}