<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Usuario extends Eloquent {

	protected $table = 'usuarios';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function roles()
	{
		return $this->hasMany('Rol');
	}

	public function configuracion()
	{
		return $this->hasOne('Configuracion');
	}

	public function viajes()
	{
		return $this->hasMany('Viaje');
	}

	public function alertas()
	{
		return $this->hasMany('Alerta');
	}

	public function envios()
	{
		return $this->hasMany('Envio');
	}

	public function saldo()
	{
		return $this->hasMany('Saldo');
	}

	public function puntuacion()
	{
		return $this->hasMany('Puntuacion');
	}

}